/*****************************************************************************
*
* Copyright 2019 NXP
* All Rights Reserved
*
*****************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/

/*!*********************************************************************************
*  @file    rotate180graph_apu_process_desc.hpp
*  @brief   ACF Process Descriptor
***********************************************************************************/

#ifndef ROTATE180GRAPHAPUPROCESSDESC_HPP
#define ROTATE180GRAPHAPUPROCESSDESC_HPP

#include <acf_process_desc_apu.hpp>
#include "rotate180graph_graph.hpp"

class Rotate180graphApuProcessDesc: public ACF_Process_Desc_APU
{
public:
  void Create()
  {
    Initialize(mGraph, "ROTATE180GRAPH");

    SetInputChunkSize(GR_INPUT0_IN, 8, 8);
    FlagInputAsChunkBasedIndirect(GR_INPUT0_IN);
  }

  Rotate180graphGraph mGraph;
};

#endif /* ROTATE180GRAPHAPUPROCESSDESC_HPP */
